/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerRegistry;
import com.blamejared.crafttweaker.api.text.FormattedTextComponent;
import com.blamejared.crafttweaker.impl.commands.CTCommands;
import com.blamejared.crafttweaker.impl.commands.CommandImpl;
import com.blamejared.crafttweaker.impl.commands.CommandUtilities;
import com.blamejared.crafttweaker.impl.loot.CTLootManager;
import com.blamejared.crafttweaker.impl.misc.CTVillagerTrades;
import com.blamejared.crafttweaker.impl_native.villager.ExpandVillagerProfession;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public final class DumpCommands {
    private DumpCommands() {
    }

    public static void registerDumpCommands(Supplier<Map<String, CommandImpl>> commands) {
        CTCommands.registerCommand(CTCommands.command("dump_brackets", "Dumps available Bracket Expressions into the /ct_dumps folder", source -> {
            File folder = new File("ct_dumps");
            if (!folder.exists() && !folder.mkdir()) {
                CraftTweakerAPI.logError("Could not create output folder %s", folder);
            }
            CraftTweakerRegistry.getBracketDumpers().forEach((name, dumpSupplier) -> {
                String dumpedFileName = dumpSupplier.getDumpedFileName() + ".txt";
                try (PrintWriter writer = new PrintWriter(new FileWriter(new File(folder, dumpedFileName), false));){
                    dumpSupplier.getDumpedValuesStream().sorted().forEach(writer::println);
                }
                catch (IOException e) {
                    CraftTweakerAPI.logThrowing("Error writing to file '%s'", e, dumpedFileName);
                }
            });
            CommandUtilities.send((ITextComponent)new StringTextComponent("Files Created"), (CommandSource)source.getSource());
            return 0;
        }));
        CTCommands.registerCommand(CTCommands.playerCommand("dump", "Dumps available sub commands for the dump command", (player, stack) -> {
            CommandUtilities.send("Dump types: ", player);
            ((CommandImpl)((Map)commands.get()).get("dump")).getChildCommands().keySet().stream().map(it -> CommandUtilities.run((TextComponent)new FormattedTextComponent("- " + CommandUtilities.color(it, TextFormatting.GREEN), new Object[0]), "/ct dump " + it)).forEach(it -> CommandUtilities.send((ITextComponent)it, player));
            return 0;
        }));
    }

    public static void registerDumpers() {
        CTCommands.registerPlayerDump("recipes", "Outputs the names of all registered recipes", (player, stack) -> {
            Registry.field_218367_H.func_201756_e().peek(type -> CraftTweakerAPI.logDump(type.toString(), new Object[0])).map(it -> player.field_70170_p.func_199532_z().field_199522_d.getOrDefault(it, Collections.emptyMap()).keySet()).flatMap(Collection::stream).map(ResourceLocation::toString).forEach(x$0 -> CraftTweakerAPI.logDump(x$0, new Object[0]));
            CommandUtilities.send(CommandUtilities.color("Recipe list generated! Check the crafttweaker.log file!", TextFormatting.GREEN), player);
            return 0;
        });
        CTCommands.registerPlayerDump("loot_modifiers", "Outputs the names of all registered loot modifiers", (player, stack) -> {
            CTLootManager.LOOT_MANAGER.getModifierManager().getAllNames().forEach(x$0 -> CraftTweakerAPI.logDump(x$0, new Object[0]));
            CommandUtilities.send(CommandUtilities.color("Loot modifiers list generated! Check the crafttweaker.log file!", TextFormatting.GREEN), player);
            return 0;
        });
        CTCommands.registerPlayerDump("loot_tables", "Outputs the names of all registered loot tables", (player, stack) -> {
            ServerLifecycleHooks.getCurrentServer().func_200249_aQ().func_215304_a().stream().map(ResourceLocation::toString).sorted().forEach(x$0 -> CraftTweakerAPI.logDump(x$0, new Object[0]));
            CommandUtilities.send(CommandUtilities.color("Loot table list generated! Check the crafttweaker.log file!", TextFormatting.GREEN), player);
            return 0;
        });
        CTCommands.registerPlayerDump("fake_players", "Outputs the data for all currently available fake players", (player, stack) -> {
            try {
                Field map = FakePlayerFactory.class.getDeclaredField("fakePlayers");
                map.setAccessible(true);
                Field mc = FakePlayerFactory.class.getDeclaredField("MINECRAFT");
                mc.setAccessible(true);
                Stream.concat(((Map)map.get(null)).keySet().stream(), Stream.of((GameProfile)mc.get(null))).map(it -> it.getName() + " -> " + it.getId()).forEach(x$0 -> CraftTweakerAPI.logDump(x$0, new Object[0]));
                CommandUtilities.send(CommandUtilities.color("Fake player data list generated! Check the crafttweaker.log.file!", TextFormatting.GREEN), player);
            }
            catch (ReflectiveOperationException e) {
                CommandUtilities.send(CommandUtilities.color("An error occurred while generating the data list", TextFormatting.RED), player);
                CraftTweakerAPI.logThrowing("Error while generating fake player list", e, new Object[0]);
            }
            return 0;
        });
        CTCommands.registerPlayerDump("villager_trades", "Outputs information on all Villager Trades", (player, stack) -> {
            VillagerTrades.field_221239_a.forEach((villagerProfession, levelToTrades) -> {
                CraftTweakerAPI.logDump("\nTrades for: " + ExpandVillagerProfession.getCommandString(villagerProfession), new Object[0]);
                levelToTrades.keySet().stream().sorted().filter(level -> ((VillagerTrades.ITrade[])levelToTrades.getOrDefault(level, (Object)new VillagerTrades.ITrade[0])).length > 0).peek(level -> CraftTweakerAPI.logDump("Level " + level + " trades", new Object[0])).map(level -> (VillagerTrades.ITrade[])levelToTrades.getOrDefault(level, (Object)new VillagerTrades.ITrade[0])).flatMap(Arrays::stream).forEach(iTrade -> {
                    String tradeStr = "Unable to display trade.";
                    if (CTVillagerTrades.TRADE_CONVERTER.containsKey(iTrade.getClass())) {
                        tradeStr = CTVillagerTrades.TRADE_CONVERTER.get(iTrade.getClass()).apply((VillagerTrades.ITrade)iTrade).toString();
                    }
                    CraftTweakerAPI.logDump(iTrade.getClass().getSimpleName() + tradeStr, new Object[0]);
                });
            });
            CommandUtilities.send(CommandUtilities.color("Trade list generated! Check the crafttweaker.log file!", TextFormatting.GREEN), player);
            return 0;
        });
    }
}

